
PmLib.ready(function(){
    const { dqs, tap } = PmLib; // import helpers
    const ted = dqs('.edit_toolbar');
    ted.style.display = 'inline-flex'; //make it visible
//== search & replace with pattern & replacement
    function replace_by_input(str) {
        if(str==='') return '';
        const etpat = dqs('.etpat');
        const etrep = dqs('.etrep');      
        const regcheck = dqs('.etregex');
        const casecheck = dqs('.etcase');
        const wordcheck = dqs('.etword');
        var pat = etpat.value;
        var rep = etrep.value;
        var mod = "";
        if (wordcheck.checked==true) {
          pat = "\\b"+pat+"\\b";
          mod = "g";
        }   
        else if (regcheck.checked==true) mod = "g";
        if     (casecheck.checked==true) mod = "gi";
        if (mod==="") result = str.replaceAll(pat, rep);
        else result = str.replace( new RegExp(pat, mod), rep);
      //  alert(pat+" ->"+rep+"<-");
        return result.replace(/\\n/g, "\n");
    }
    const replacetool = dqs('.replaceTool');
    if(replacetool) tap(replacetool, function(){ // onclick
        const allcheck = dqs('.etall');
        if (allcheck.checked==true) document.getElementById("text").select(); 
        insMarkup(replace_by_input);
    }); 
//== replace line-breaks with spaces
    const renltool = dqs('.removenlTool');
    function remove_line_breaks(str) {
      if(str==='') return '';
      let result = str
        .replace(/\r\n?/g, "\n") // normalize line breaks
        .replace(/([^\n\s])\s*\n\s*([^\n\s])/g, "$1 $2")   // join lines
      ;
      return result;
    }
    if(renltool) tap(renltool, function(){ // onclick
      const allcheck = dqs('.etall');
      if (allcheck.checked==true) document.getElementById("text").select(); 
      insMarkup(remove_line_breaks);
    });
//== trim spaces from start and end of lines
    const trimtool = dqs('.lineTrimTool');
    function trim_lines_in_selection(str) {
      if(str==='') return '';
      return str.replace(/^\s+|\s+$/gm,'');
    }
    if(trimtool) tap(trimtool, function(){ // onclick
      const allcheck = dqs('.etall');
      if (allcheck.checked==true) document.getElementById("text").select(); 
      insMarkup(trim_lines_in_selection);
    });
//== convert to Title Case
    function title_case_convert(str) {
      let upper = true; let newStr = "";
      for (let i = 0, l = str.length; i < l; i++) {
        if (str[i].match(/[\s\!\'-]/)) {
          upper = true; newStr += str[i]; continue;
        }
        newStr += upper ? str[i].toUpperCase() : str[i].toLowerCase();
        upper = false;
      }
      return newStr;
    }
    const titletool = dqs('.toTitleTool');
    if(titletool) tap(titletool, function(){
      const allcheck = dqs('.etall');
      if (allcheck.checked==true) document.getElementById("text").select(); 
      insMarkup(title_case_convert);}); 
//== convert to UPPER CASE
    const uppertool = dqs('.toUpperTool');
    function upper_case_convert(str){return str.toUpperCase();}
    if(uppertool) tap(uppertool,function(){
      const allcheck = dqs('.etall');
      if (allcheck.checked==true) document.getElementById("text").select(); 
      insMarkup(upper_case_convert);}); 
//== convert to lower case
    const lowertool = dqs('.toLowerTool');
    function lower_case_convert(str){return str.toLowerCase();}
    if(lowertool) tap(lowertool,function(){
      const allcheck = dqs('.etall');
      if (allcheck.checked==true) document.getElementById("text").select(); 
      insMarkup(lower_case_convert);}); 

}); 

