<?php if (!defined('PmWiki')) exit();
/*
-----------------------------------------------------------------------------------
      * Cookbook Function for counting lines between two markers *
                     Written by (c) Holger Kremb 2026
        Tested with PHP 8.5.2 - last tested on PmWiki version: 2.5.5

  This text is written for PmWiki; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free Software
  Foundation; either version 3 of the License, or (at your option) any later
  version. See pmwiki.php for full details and lack of warranty.
-----------------------------------------------------------------------------------
  Usage:
    (:pmlinecount start="[[#Pm_Start]]" end="[[#Pm_End]]":)

  Other page:
    (:pmlinecount page=Group.Page start="[[#Pm_Start]]" end="[[#Pm_End]]":)

  Note:
    "Pm_" must precede the actual marker name to prevent marker duplication
    when anchors are rendered by PmWiki.
-----------------------------------------------------------------------------------
  Cookbook file : countbetweenmarkers.php
  Markup        : (:pmlinecount:)
  PHP function  : CountBetweenMarkers()

  Copyright 2026 Holger Kremb
  https://kremb.net
-----------------------------------------------------------------------------------
*/

# Version date
$RecipeInfo['CountBetweenMarkers']['Version'] = '20260123';
$FmtPV['$CountBetweenMarkers'] = "'CBM-{$RecipeInfo['CountBetweenMarkers']['Version']}'";

# Function
function CountBetweenMarkers($m) {
  global $pagename;

  $opt = ParseArgs($m[1]);
  $page  = (!empty($opt['page'])) ? MakePageName($pagename, $opt['page']) : $pagename;
  $start = isset($opt['start']) ? (string)$opt['start'] : '';
  $end   = isset($opt['end'])   ? (string)$opt['end']   : '';

  if ($start === '' || $end === '') return '';

  # Allow markers passed as [[#Pm_Start]] and map them to #Start
  if (preg_match('/^\s*\[\[\s*#Pm_([^\]\s]+)\s*\]\]\s*$/', $start, $mm)) $start = '#'.$mm[1];
  if (preg_match('/^\s*\[\[\s*#Pm_([^\]\s]+)\s*\]\]\s*$/', $end,   $mm)) $end   = '#'.$mm[1];

  $p = ReadPage($page, READPAGE_CURRENT);
  $txt = isset($p['text']) ? (string)$p['text'] : '';
  if ($txt === '') return '0';

  $lines = preg_split("/\r\n|\n|\r/", $txt);

  $in = false;
  $c = 0;

  foreach ($lines as $ln) {
    if (!$in) {
      if (strpos($ln, $start) !== false) $in = true;
      continue;
    }
    if (strpos($ln, $end) !== false) break;
    $c++;
  }

  return (string)$c;
}

# Markup
Markup_e(
  'pmlinecount',
  'directives',
  '/\\(:pmlinecount\\s*(.*?)\\s*:\\)/',
  'CountBetweenMarkers'
);