<?php
  session_start();
  require_once '_setup.php'   ;
  
  $user_reset = new USER()   ;

  if(empty($_GET['id']) || empty($_GET['token']))
  { $user_reset->redirect('index.php') ; }  

  if(isset($_GET['id']) && isset($_GET['token']))
  {
     $id = base64_decode($_GET['id']) ;
     $token = $_GET['token']            ;
     
     $rawStmt = "SELECT * FROM ".DB_TBL_USERS." WHERE ".DB_USER_IDX."=:uid AND ".DB_USER_TOKEN."=:token" ;
     $stmt = $user_reset->runQuery($rawStmt)               ;
       $stmt->execute(array(":uid"=>$id,":token"=>$token)) ;
       $rows = $stmt->fetch(PDO::FETCH_ASSOC)              ;
     
     if($stmt->rowCount() == 1)
     {
        if(isset($_POST['btn-reset-pass']))
        {
            $pass     = $_POST['pass']         ;
            $cpass    = $_POST['confirm-pass'] ;
            $password = md5($cpass)            ;

            $PWtest = trim(checkPWord($cpass)) ;

            if (!empty($PWtest))
            { $msg = $PWtest  ;
            }else
            {           
                 if($cpass!==$pass)
                 {
                    $msg = "Sorry!</strong>  Password doesn't match." ;
                 }else // $cpass==$pass
                 {
                    $rawStmt = "UPDATE ".DB_TBL_USERS." SET ".DB_USER_PW."=:upass WHERE ".DB_USER_IDX."=:uid";
                    $stmt = $user_reset->runQuery($rawStmt) ;
                    try
                    {
                      $stmt->execute(array(":upass"=>$password,":uid"=>$rows[DB_USER_IDX])) ;
                      $_SESSION['jump'] = "" ;

                      $msg = "Password Changed! <br />
                              <br />
                              <h4>Redirecting to Login Page ...</h4>" ;

                      header("refresh:5; index.php") ;
                    }
                    catch(PDOException $ex)
                    { $msg = $ex->getMessage() ; }
                 }// $cpass==$pass
            }
        }// $_POST['btn-reset-pass']
     }else  //Couldn't Match ID and CODE
     { exit; }
  }

  function checkPWord($pwd) 
  {
      $errors = "" ;
      $pattern = '/[\'\/~`\!@#\$%\^&\*\(\)_\-\+=\{\}\[\]\|;:"\<\>,\.\?\\\]/' ;

      if ( strlen($pwd) < 8)                  { $errors .= "Password too short! (Minimum of 8 Characters)<br />"         ; }
      if (!preg_match("#[0-9]+#", $pwd))      { $errors .= "Password must include at least one number!<br />"            ; }
      if (!preg_match("#[a-z]+#", $pwd))      { $errors .= "Password must include at least one Lower-Case letter!<br />" ; }
      if (!preg_match("#[A-Z]+#", $pwd))      { $errors .= "Password must include at least one Upper-Case letter!<br />" ; }  
      if (!preg_match($pattern,   $pwd))      { $errors .= "Password must include at least one Special Character!<br />" ; }    

      return trim($errors) ;
  }    

?>
<!DOCTYPE html>
<html>
  <head>
    <title>Password Reset</title>
    <link rel="stylesheet"   href="login.css"  />
  </head>
  <body id="login">    
    <div class="container">
      <h1>Password Reset Page</h1>
      <div class='alert alert-success'>
        <h2><strong>Hello </strong>  <?php echo $rows['userName'] ?>!<br />
        <h3>        You are here to reset your forgetton password.</h3>
        </h2>
      </div>
      <hr />
          <div class="CommBox">
            <h3> <?php  
                    if(isset($msg)) 
                    {  echo  $msg ; }
                    else
                    {  echo "Please Enter the New Password Twice" ; } 
                 ?>                 
            </h3>
          </div>

      <form class="form-signin" method="post">
        <input  type="password" 
                class="input-block-level" 
                placeholder="New Password" 
                name="pass" 
                required
                size="25" /><br />
        <input  type="password" 
                class="input-block-level" 
                placeholder="Confirm New Password" 
                name="confirm-pass" 
                required
                size="25" /><br />
                <h3>Password Rules - at least 8 characters, Upper-Case & Lower-Case, <br />
                  A Number, and a Special Character: &nbsp; &nbsp;~ ! @ | # $ % ^ & * + - _ = < > ? </h3>
          <br /><br />
        <button class="btn btn-large btn-primary" 
                type="submit" 
                name="btn-reset-pass">
            Reset Your Password
        </button>
        
      </form>

    </div>
    <script>// We use this to 'auto-size' the iFrame to match this page as a guest
            parent.SizeMyFrame();</script>      
</body>
</html>