<?php
    require_once '_setup.php'   ;
    session_start() ;

    $user_home = new USER()    ;

    // Just in case, we bounce anyone not logged-in back to the index.php page
    if(!$user_home->is_logged_in())
    { $user_home->redirect('index.php') ; }

    // fetch user ID Token to validate login - Using a Session variable saved on login.
    $rawStmt = "SELECT * FROM ".DB_TBL_USERS." WHERE ".DB_USER_TOKEN."=:utoken";
    $stmt = $user_home->runQuery($rawStmt) ;
        $stmt->execute(array(":utoken"=>$_SESSION['userToken'])) ;
        $row = $stmt->fetch(PDO::FETCH_ASSOC) ;

?>

<!DOCTYPE html>
<html>
    
    <head>
        <title>Embedded MyDBLogin Landing Page</title>
        <link rel="stylesheet"   href="login.css"  />             
    </head>
    
    <body>        
        <?php 
            if ($ShowDebug)
            {   
                echo "<div><br />"                                          ;
                echo "Session ID: &nbsp;". session_id()     . "<br />"      ; 
                echo "Synch_ID = "  . $_SESSION['Synch_ID'] . "<br />"      ;
                echo "My URL: &nbsp; &nbsp;" . WIKIHOST.WIKIROOT . "<br />" ;
            }
        ?>
        
        <div>
            <h2>Log-in Success!</h2>
            <div >
                <ul>
                    <li>                         
                        <h3><?php 
                            echo  "Logged-In As:      <br />" ;
                            echo  $row['user_name'] ."<br />" ;
                            echo  $row['user_email']."<br />" ;
                            ?>
                        </h3> 
                    </li>
                    <li >                         
                        <h3><?php 
                                echo  "With user Level set to: <br />"  ;
                                echo  $_SESSION['AuthLevel']            ;
                            ?>
                        </h3> 
                    </li>   
                    <br /><br />
                    
                    <hr />
                    <h3><a tabindex="-1" href="logout.php">
                            Logout
                        </a>
                    </h3>   

                    <h3><a tabindex="-1" href="fpass.php">
                            Change Your Password
                        </a>
                    </h3>                                   
                </ul>
            </div>
        </div>
        <?php 
            if ($ShowDebug)
            {
                echo  "<div><br />" ;
                echo  "ValidLogin Tag: "             . $_SESSION['MyDBValid']  . "<br />"  ;
                echo  "AuthMsg Tag: "                . $_SESSION['AuthMsg']    . "<br />"  ;
                echo  "<br />" ;
                echo  "Logged-In As:   "             . $_SESSION['UserName']   . "<br />"  ;
                echo  "Email:  "                     . $_SESSION['UserEmail']  . "<br />"  ;
                echo  "with pw:  "                   . $_SESSION['UserPass']   . "<br />"  ;
                echo  "User ID-Token:  "             . $_SESSION['userToken']  . "<br />"  ; 
                echo  "With user Level set to:  "    . $_SESSION['AuthLevel']  . "<br />"  ;  
                echo  "</div>" ;

                //print_r($_SESSION);   // Display all user registered Session variables.
            }   
        ?>
        

    <script>// We use this to 'auto-size' the iFrame to match this page as a guest
            parent.SizeMyFrame();</script>      
</body>
</html>