<?php

/**----------------------------------------------------------------------------
    _setup.php  External MySQL user authentication for PMWiki  
    Original content Copyright 2021 Kirk Siqveland (Kirk@CyberTamer.com)

    - This includes a variation of the code from the includeSite recipe
           includeSite.php - see Original Copyright at bottom.

    This file is distributed under the terms of the GNU General Public 
    License as published by the Free Software Foundation; either 
    version 2 of the License, or (at your option) any later version.  

    MyDBLogin uses a simple set of MySQL pages embedded via an iFrame to be
    used within a PMWiki installation to control access to page Groups or 
    even individual pages.  You will need the other files in the recipe for
    this to work.

    For all the files and instructions goto:
    https://www.pmwiki.org/wiki/Cookbook/MyDBLogin

-------------------------------------------------------------------------------**/



## ! ! ! !  C H A N G E   T H E S E   F O R   Y O U R   L O C A T I O N   ! ! ! ! !
#  -  Configure the MyDBLogin variables
#  -  Configure the PHPMailer variables
#  -  Configure the MySQL Variables  
#     ( this is outside of PMWiki so no DB configuration is required for PMWiki )

##_______________________________________________________________________________________________
##
##          <>>>>    M y D B L o g i n   S e t t i n g s   f o r   P M W i k i    <<<>
##_______________________________________________________________________________________________ 

//$WikiLoginPage = $ScriptUrl.'/Turnstile/Validate' ;


##>>>  Declare the Path to YOUR directory with pmwiki.php 
##  Normally that would be:
      define(WIKI_PATH, "/pmwiki") ;

##  If you just use a different name for the wiki folder it might look like:
      //    define(WikiPath, "/SomeFolder") ;

    ## If your installation is at the Domain level (A Bad Idea!) 
    ## For example your PMWiki files are located at http://www.mysite.com/ then
      //   define(WikiPath, "") ; 

    ## If your installation several directories deep:
    ## For example  https://www.mysite.com/somedirectory/anotherone/pmwiki  then
      //   define(WikiPath, "/somedirectory/anotherone/pmwiki") ;    
   
##>>>  Declare the location of the MyDBLogin files (index.php, signup.php etc.)
##  MyDBLogin Files MUST be in the same domain, but NOT in the PMWiki path
##  If for example the MyDBLogin directory is at www.myexample.com/mydblogin 
##  You would use:   
//          define(MYDBLOGIN_PATH, "/mydblogin") ; 
    define(MYDBLOGIN_PATH, "/mydblogin") ;      
##  Yes, we aready defined this in config.php, but this file is not linked yet...

##>>>  Declare the PMWiki Group / Page for Verification.
## e.g.: www.myexampledomain.org/pmwiki/pmwiki.php?n=Access" 
    //      define(MY_WIKI_LOGIN, "Turnstile/Validate") ; 
    // or   define(MY_WIKI_LOGIN, "Turnstile.Validate") ; 
    define(MYDBL_WIKI_LOGIN, "Turnstile/Validate") ;

##>>>  Declare the PMWiki Group / Page for Verification.
## e.g.: www.myexampledomain.org/pmwiki/pmwiki.php?n=Access" 
    //      define(MYDBL_NEED_AUTH, "Turnstile/Validate") ; 
    // or   define(MYDBL_NEED_AUTH, "Turnstile.NeedAuth") ; 
    define(MYDBL_NEED_AUTH, "Turnstile/NeedAuth") ;   


##>>>  A Secret key to encrypt the Session ID for GET transfers
    define(SSL_KEY, "YourSecretKey") ;
    $SSLkey = "YourSecretKey";    

##>>>  Enable Debug Messages - when you are setting things up if you have problems 
##     Set this to = true ;  and you will get a lot of information to help debug.
    $ShowDebug   =  false ;    


## ! ! ! Please Note the MyDBLogin files should be in the SAME domain, but must NOT be in 
##       the PMWiki installation, otherwise you will not have authorization to see them!
##       For Example your PMWiki is at:   https://www.mydomain/pmwiki/
##       But your MyDBLogin files are at: https://www.mydomain/mydblogin/
##
## Trouble-shooting? Try logging directly into the MyDBLogin files  
##       (Here's another reason not to put your PMWiki installation at the Web Root!)


##_______________________________________________________________________________________________
##
##              <>>>>   PHPMailer Settings   <<<>
##_______________________________________________________________________________________________ 

## Configure to match your email server account
  define(SMTPHOST,      'smtp.exampledomain.org')         ; // Mail host (with PHPMailer rights/setup)
  define(SMTPMAILUSER,  'webmanager@exampledomain.org')   ; // Mailuser Username
  define(SMTPMAILPW,    'WebmanagersPassword')            ; // Mailuser Password

  define(SMTPFROM,      'webmanager@exampledomain.org')   ; // Validation mails will show as From:
  define(SMTPFROMTAG,   'Example Domain User Validation') ; // Validation Emails Declare the site name as:
  define(SMTPTOTAG,     'Example Domain Visitor')         ; // Addressee title for the Validation email


## PHPMailer include file locations
## Change 'yourusername' to your actual username:
  require '/home/yourusername/PHPMailer/src/Exception.php'  ; 
  require '/home/yourusername/PHPMailer/src/PHPMailer.php'  ;
  require '/home/yourusername/PHPMailer/src/SMTP.php'       ;  


## This Assumes PHPMailer is installed in its default directory
## If not, change these to match your installation (ask your web-host)
  use PHPMailer\PHPMailer\PHPMailer ;
  use PHPMailer\PHPMailer\Exception ;




##_______________________________________________________________________________________________
##
##              <>>>>   MYSQL Settings   <<<>
##_______________________________________________________________________________________________ 


## Use this setting to identify your Site in the Welcome / Verify emil for new Registrants
## Just use the Site Name or the Organization Name
  $SiteName   =         "exampledomain"            ;
  $WelcomeTo  =         "the $SiteName Website" ; // Displays as "the exampledomain Website"

## Set the Database Credentials:
  define(DB_HOST,       'mysql.exampledomain.org') ; // Maybe localhost but not for my provider...
  define(DB_NAME,       'mydblogin_db')            ; // Name of the Database we are using
  define(DB_USER,       'db_user_name')            ; // Username for logging into the database
  define(DB_PWORD,      'db_password')             ; // Password for logging into the database


## - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ##

## Set the Database information for the DB with the list of available User-Emails:
## If you used the CREATE scripts in the ~HowTo.txt file you do not need to change these:

  define(DB_TBL_WHTLST, 'mydb_whitelist')      ; // Table with allowable email list
  define(DB_WHITELIST,  'wlst_email')          ; // Field containing allowable emails
  define(DB_TBL_USERS,  'mydb_users')          ; // Table of Registered Users
  define(DB_USER_IDX,   'user_idx')            ; // Field with Index ID of User
  define(DB_USER_NAME,  'user_name')           ; // Field with User Username
  define(DB_USER_EMAIL, 'user_email')          ; // Field with User email

  define(DB_USER_PW,    'user_pw')             ; // Field with User password
  define(DB_USER_LEVEL, 'user_auth_level')     ; // Field with User authority level e.g. admin
  define(DB_USER_CODE,  'user_auth_code')      ; // Field with Password authority level
  define(DB_USER_TOKEN, 'user_token')          ; // Field with last session id
  define(DB_USER_STATUS,'user_status')         ; // Field Flag validated user (via email)




 //\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
//__________________________________________________________________________________\\

//     YOU SHOULD NOT NEED TO CUSTOMIZE ANYTHING BELOW HERE FOR A NORMAL INSTALL    \\
//__________________________________________________________________________________\\



## HTTPS / HTTP Auto-finder:
## Identify the site as either an https or an http site: and Assign it to a Constant
## The Next few Settings allow you to Localize the different PHP files ONCE then use 
## Variables instead of hard-code.  This makes migration and new installations easier!
##
## Function to check if the current installation url uses an https or http prefix
    function check_https() 
    { if ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || $_SERVER['SERVER_PORT'] == 443) 
      { return true  ; }
      else
      { return false ; }
    }
##
## First we identify the site as either an https or an http site:
    if (check_https()) 
    {   if (!defined('WIKIHOST')) { define('WIKIHOST', 'https://'. $_SERVER['HTTP_HOST']) ; } 
    } else {
        if (!defined('WIKIHOST')) { define('WIKIHOST', 'http://' . $_SERVER['HTTP_HOST']) ; } 
    } 
################################################################################################


##  Use the User-Defined variables to set our paths:
  if (!defined('WIKIROOT')){ define('WIKIROOT', WIKI_PATH) ; }
    
  $MyDBLoginRoot = WIKIHOST.MYDBLOGIN_PATH                              ;  
  $MyDBLoginWiki = WIKIHOST.WIKI_PATH."/pmwiki.php?n=".MYDBL_WIKI_LOGIN ;

##  Prep our Session ID variable
  if(!isset($SynchID)) { $SynchID = "" ; }


################################################################################################
##                    C L A S S E S :
################################################################################################

## There are two Classes here DATABASE and  USER

## Database: handles the Database Connection, and 
## User: handles 
## - Login/Logout routines, 
## - Registration with confirmation via Email
## - some Database functions

class Database
{
     
    ## Set the Database Credentials:     
    private $host     = DB_HOST  ;
    private $db_name  = DB_NAME  ;
    private $username = DB_USER  ;
    private $password = DB_PWORD ;
    public  $connect             ;
     
    public function dbConnection()
    {     
        $this->conn = null ; 

        try
        {   $this->conn = new PDO("mysql:host=" . $this->host . ";dbname=" . $this->db_name, $this->username, $this->password) ;
            $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION) ; 
        }
        catch(PDOException $exception)
        {   echo "Connection error: " . $exception->getMessage() ; }
         
        return $this->conn ;
    }
}

class USER
{ 
  private $conn;
 
  public function __construct()
  { $database = new Database()        ;
    $db = $database->dbConnection()   ;
    $this->conn = $db                 ;
  }
 
  public function runQuery($sql)
  { $stmt = $this->conn->prepare($sql) ;
    return $stmt ; 
  }
 
  public function lastID()
  { $stmt = $this->conn->lastInsertId() ;
    return $stmt ;
  }

  public function register($uname,$email,$upass,$token)
  {
    try
    {   $rawStmt = "INSERT INTO ".DB_TBL_USERS."(".DB_USER_NAME.",".DB_USER_EMAIL.",".DB_USER_PW.",".DB_USER_TOKEN.") 
                    VALUES(:user_name, :user_email, :user_pw, :user_token)";
        $stmt = $this->conn->prepare(   $rawStmt)  ;
        $stmt->bindparam(":user_name",  $uname)    ;
        $stmt->bindparam(":user_email", $email)    ;
              $password = md5($upass)              ;
        $stmt->bindparam(":user_pw",    $password) ;
        $stmt->bindparam(":user_token", $token)    ;
        $stmt->execute()                           ; 

        return $stmt                               ;
    }
    catch(PDOException $ex)
    {
        echo $ex->getMessage() ;
    }
  }

  public function login($uname,$email,$upass,$synchid)
  {
    try
    {
        #echo "                             Username: ".$uname."   Email: ".$email ;
        if(strlen($uname)>0)
        {
          $stmt = $this->conn->prepare("SELECT * FROM ".DB_TBL_USERS." WHERE ".DB_USER_NAME."=:uname_id") ;
          $stmt->execute(array(":uname_id"=>$uname)) ;
          $userRow=$stmt->fetch(PDO::FETCH_ASSOC)    ;
        }else
        { 
          $stmt = $this->conn->prepare("SELECT * FROM ".DB_TBL_USERS." WHERE ".DB_USER_EMAIL."=:email_id") ;
          $stmt->execute(array(":email_id"=>$email)) ;
          $userRow=$stmt->fetch(PDO::FETCH_ASSOC)    ;       
        }
     
       if($stmt->rowCount() == 1)
       {
          if($userRow[DB_USER_STATUS]=="Y")
          {
             if($userRow[DB_USER_PW]==md5($upass) )
             {                  
                  session_id( $synchid );
                  session_start();
                  $_SESSION['MyDBValid']  = "Validated User"         ;
                  $_SESSION['userToken']  = $userRow[DB_USER_TOKEN]  ;  
                  $_SESSION['UserName']   = $userRow[DB_USER_NAME]   ;
                  $_SESSION['UserEmail']  = $userRow[DB_USER_EMAIL]  ;
                  $_SESSION['AuthLevel']  = $userRow[DB_USER_LEVEL]  ;
                  $_SESSION['AuthCode']   = $userRow[DB_USER_CODE]   ;

                  return "success" ;
             }
             else
             {    return "NoMatch" ;}
          }else{  return "NotActive" ;} 
       }else{     return "NoMatch" ; }  
    }
    catch(PDOException $ex)
    { echo $ex->getMessage() ; }
  }
 
 
  public function is_logged_in()
  {
    if(strlen($_SESSION['userToken'])>0)
    { return true ; }
  }
 
  public function redirect($url)
  {  header("Location: $url") ; }
 
  public function logout()
  { 
    $_SESSION['MyDBValid']    = NULL ;
    $_SESSION['userToken']    = NULL ;
    $_SESSION['UserName']     = NULL ;
    $_SESSION['UserEmail']    = NULL ;
    $_SESSION['AuthLevel']    = NULL ;
    //$_SESSION['AuthCode']     = NULL ;
    session_destroy()                ; 
  }


  /* -------- PHPMailer Send Mail Function ---------------------------------------- */
  function send_mail($email,$message,$subject)
  {      

    $mail = new PHPMailer(true) ;                 // Passing `true` enables exceptions
    
    try {
          //Assign Server settings
          $mail->SMTPDebug  = 0            ;      // Enable verbose debug output
          $mail->isSMTP()                  ;      // Set mailer to use SMTP
          $mail->Host       = SMTPHOST     ;      // Specify main and backup SMTP servers
          $mail->SMTPAuth   = true         ;      // Enable SMTP authentication
          $mail->Username   = SMTPMAILUSER ;      // SMTP username
          $mail->Password   = SMTPMAILPW   ;      // SMTP password
          $mail->SMTPSecure = 'tls'        ;      // Enable TLS encryption, `ssl` also accepted
          $mail->Port       = 587          ;      // TCP port to connect to

          //Recipients
          $mail->setFrom(SMTPFROM, SMTPFROMTAG) ;      //This is the email your form sends From
          $mail->addAddress($email, SMTPTOTAG)  ;      // Add a recipient address
          //$mail->addAddress('contact@example.com') ; // Name is optional
          //$mail->addReplyTo('info@example.com', 'Information') ;
          //$mail->addCC('cc@example.com') ;
          //$mail->addBCC('bcc@example.com') ;

          //Attachments
          //$mail->addAttachment('/var/tmp/file.tar.gz') ;         // Add attachments
          //$mail->addAttachment('/tmp/image.jpg', 'new.jpg') ;    // Optional name

          //Content
          $mail->isHTML(true)       ;                              // Set email format to HTML
          $mail->Subject = $subject ;
          $mail->Body    = $message ;
          //$mail->AltBody = 'This is the body in plain text for non-HTML mail clients' ;

          $mail->send() ;

          return '1 - Message has been sent' ;

    } catch (Exception $e) 
    {
          $retStr = "0 - Message could not be sent. \r\n Mailer Error: ".$mail->ErrorInfo ;
          return $retStr ;
    }
  } //  function send_mail
} //  class USER
