<?php
if (!defined('PmWiki')) exit();

/**----------------------------------------------------------------------------
    Turnstile.Template.php  
    for MyDBLogin - External MySQL user authentication recipe for PMWiki  
    Copyright 2021 Kirk Siqveland (Kirk@CyberTamer.com)

    This file is distributed under the terms of the GNU General Public 
    License as published by the Free Software Foundation; either 
    version 2 of the License, or (at your option) any later version.  

    MyDBLogin uses a simple set of MySQL pages embedded via an iFrame to be
    used within a PMWiki installation to control access to page Groups or 
    even individual pages.  You will need the other files in the recipe for
    this to work.

    For all the files and instructions goto:
    https://www.pmwiki.org/wiki/Cookbook/MyDBLogin

-------------------------------------------------------------------------------**/

## This is the template code we use to restrict access to a Group or Page 


## You will make a copy of this file for each Group or Group.Page where
## you wish to limit/grant access using the MyDBLogin tool.
##
## To restrict access to any Wiki-Group in your pmwiki site, simply rename 
## a copy of this file to the same name as the Group (but with the .php ending) 
## and save it to your pmwiki/local folder.
## E.g. copy this file, rename it "Members.php" in order to restrict access
## to ALL pages in the PMWiki Group  "Members" located at say 
##    www.mydomain.org/pmwiki/pmwiki.php?n=Members
## Or for a single page within Members, say the Members/Directory page:
##    www.mydomain.org/pmwiki/pmwiki.php?n=Members.Directory
## You would make a copy of the Turnstile.Template.php file and rename it:
## Members.Directory.php
## And then saved in the pmwiki/local folder 
## Which sends anyone not Logged in at the right level, to the 
## "NoAuth" page defined in the setup.php file in the mydblogin directory.

## For more information on Groups in PMWiki:
##    https://www.pmwiki.org/wiki/PmWiki/GroupCustomizations

## !!! Be sure you have correctly set everything in the _setup.php file !!!
##
## Now you only need to change the $ALevel code below to handle the level
## of access you wish to allow.

## First we get the Logged-in Authorization Level from a Session variable:
    $ALevel = $_SESSION['AuthLevel'] ;  

## For users already logged-in, we decide what to do based on their $Alevel.

## NOTE: Do nothing simple allows the page-load normally you may not need 
##       anything more than just that!

## Here I defined 'Admin' or 'Manage' or 'Read' to all have page access,
## everyone else gets directed to the $NoAuthPage in your PMWiki install;
## where you should direct them how to proceed without authorization...

## NOTE: this does NOT grant edit or admin rights to the PMWiki itself.
## We do that elsewhere in the MyDBLogin code. (See the mydblogin/index.php)   

    switch ($ALevel) {

      case "Admin":
        ## code to be executed if Authorization Level = Admin;
        ## or leave as-is to just allow access to the page/group
        break;

      case "Manage":
        ## code to be executed if Authorization Level = Manage;
        ## or leave as-is to just allow access to the page/group
        ## or comment-out this section to default to not-authorized.
        break;

      case "Edit":
        ## code to be executed if Authorization Level = "Read";
        ## or leave as-is to just allow access to the page/group
        ## or comment-out this section to default to not-authorized.
        break;

      case "Read":
        ## code to be executed if Authorization Level = "Read";
        ## or leave as-is to just allow access to the page/group
        ## or comment-out this section to default to not-authorized.
        //header("Location: $ScriptUrl/$MyDBL_NeedAuth");
        ## or - go straight to sign-in:
        header("Location: $ScriptUrl/$MyDBL_NeedAuth");

        break;

      default:
        ## Redirect to the Sign-in Page
        ## MAKE SURE TO CHANGE TO YOUR VALIDATE PATH!
        //header("Location: $ScriptUrl/$MyDBL_NeedAuth");
        ## or - go straight to sign-in:
        header("Location: $ScriptUrl/$MyDBL_WikiPage");
    }