<?php
if (!defined('PmWiki')) exit();

/**----------------------------------------------------------------------------
    mydblogin.php  External MySQL user authentication for PMWiki  
    Original content Copyright 2021 Kirk Siqveland (Kirk@CyberTamer.com)

    - This includes a variation of the code from
      includeSite.php - see Original Copyright at bottom.

    This file is distributed under the terms of the GNU General Public 
    License as published by the Free Software Foundation; either 
    version 2 of the License, or (at your option) any later version.  

    MyDBLogin uses a simple set of MySQL pages embedded via an iFrame to be
    used within a PMWiki installation to control access to page Groups or 
    even individual pages.  You will need the other files in the recipe for
    this to work.

    For all the files and instructions goto:
    https://www.pmwiki.org/wiki/Cookbook/MyDBLogin

-------------------------------------------------------------------------------**/

##   MyDBLogin recipe is a parallel authentication to the default PMWiki passwords.
##   It can be applied to a single page or a group of pages.
##   On my ToDo list is a more refined user/group/page authorization tool.

##   This is a Username/Password system, using a MySQL database and PHPMailer.
##   (You will need the Database and PHPMailer set up on your domain server.)
##
## - Users can self register - based on a email-whitelist table
## - Users can set / use a UserName or the whitelisted email to login.
## - Users can set / change passwords using an email confirmation tool.
## - A 'Forgot-Password tool' uses email confirmation to reset the password.
## - Authenticated users 'blindly' use the default pmwiki access passwords.
##   e.g. After logging in the Database identifies the user as having
##   "Edit" access to the site and a the proper "Edit" password is assigned
##   to a Session Variable, but never passed outside of the PMWiki server.

SDV($RecipeInfo['MyDBLogin']['Version'], '2021-03-17');
$FmtPV['$MyDBLoginVersion'] = "'{$RecipeInfo["MyDBLogin"]["Version"]}'";

$MYDBL_LastPage = "" ;


## Function to check if the current installation url uses an https or http prefix
  function valid_https() {    
    if ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || $_SERVER['SERVER_PORT'] == 443) {
      return true; 
    }else{
      return false;}
  }

## I normally have a version of this in my config.php file - but just to be sure I put it here:
  if (valid_https()) {
    if (!defined('SITEHOST')){ define('SITEHOST', 'https://'.$_SERVER['HTTP_HOST']); }
  } else {
    if (!defined('SITEHOST')){ define('SITEHOST', 'http://'. $_SERVER['HTTP_HOST']); }
  } 

  $MyDBLoginURL = SITEHOST.$MyDBLoginDir."/index.php" ;
  $MyDBWikiPage = SITEHOST."?n=".str_replace("/",".",$MyDBL_WikiPage);


## Here We Go - 
## If everything was set correctly this logs into PMWiki using the authorizations we set.
## This will only run once a new page is loade or current page is refreshed - 
## I avoid the scripting issues here by not trying to force the page load.
  if($_SESSION['MyDBValid']  == "Validated User" )
  {
      //SessionAuth($pagename, array('authid' => $_SESSION['UserName'], 'authlist' => $_SESSION['AuthClass'])) ;
      SessionAuth($pagename, array('authpw' => array($_SESSION['AuthCode'] => 1))) ;
  }  



##_______________________________________________________________________________________________
##
##              <>>>>   The MyDBLogin Embedding Tool   <<<>
##_______________________________________________________________________________________________  
##
#
#   This is a variant of my BridgeSite recipe which in turn is a derivative of the includeSite recipe
#   Which we use, with some Session-Magic, to embed a set of simple Login Pages within a single 
#   PMWiki page to handle the MyDBLogin authorization tool allowing us to easily use
#   MySQL & PHPMailer to allow users to manage their individual Logins.
#

function MyLoginPage($m) {  
  GLOBAL $MyDBLoginURL ;
  ## $m -> an array with the parameters matches
  ## $m[0] -> the whole match, everything between  '(:MyLoginPage'  and  ':)'
  ## $m[1] -> subgroup 2 : the parameters

  ##  parse the parameters: options id, class, style, and 'get' params, otherwise ignore...
  ##  This allows the iframe to be given a CSS id or class as well as setting inline styles,
  ##  and fianlly allows getvar's to be passed when calling the embedded (iFramed) page.
    $pattern = '/(id|class|style|getvar)=((\\d+)|(["\'])(.*?)\4)/'; 

    $results = preg_match_all($pattern,$m[1],$match,PREG_SET_ORDER);

    $bridge_params = "";

      foreach ($match as $part) {
        switch (substr($part[0],0,2)) {
            case ' id':        # id
              $id      = " id="       ;
              $id     .= $part[5]     ;
              $id     .= "\""         ;
              $bridge_params .= $id  ;
              break;

            case 'cl':        # class
              $class  = " class=\""     ;
              $class .= $part[5]        ;
              $class .= "\""            ;
              $bridge_params .= $class  ;
              break;     

            case 'st':        # style
              $style  = " style=\""     ;
              $style .= $part[5]        ;
              $style .= "\""            ;              
              $bridge_params .= $style  ;
              break;

            case 'ge':        # getvar
              $getvar .= "&".substr($part[5],6)     ;             
              break;              
        }
      }



##  ## I keep this function in a cookbook/common.php file I use across my different PMWiki installations
##  ## It is handy for several recipes. 
    function synch_session(){
      global $SynchID;
      if(empty($SynchID)){
          $rndID = uniqid();
          session_id($rndID) ;
        @session_start() ;
        $SynchID              = session_id() ;
        $_SESSION['Synch_ID'] = session_id() ;
      }
    }       


  ## This Adds the Session ID as a GET to the iFrame address, so the two windows can pass messages.
    synch_session()      ;
    $URLExtra  = "?"     ;
    $HOSTSID   = "SSID=" ;
    $HOSTSID  .= openssl_encrypt($SynchID, "AES-128-ECB", $SSLkey);
    //$HOSTSID  .= session_id();

    $URLExtra .= $HOSTSID.$getvar;


  ## Now We prepare All the Code to insert using the Markup:
  ## This includes adding javascript to handle window sizing/refresh
    $Output  =  "<!-- MyLoginPage: --> ";
    ## Notice we add an html width of 100% which works well as a default.
    $Output .= "<iframe class=\"LoginFrame\" id=\"MyDBLogin\"width=100% " . $bridge_params ;
    $Output .= "  src=\"" .keep($MyDBLoginURL).$URLExtra."\" scrolling=\"no\" onload=\"SizeMyFrame()\"></iframe>\r\n" ;
    ## Now we add some scripts to handle changing sizes for the guest page. E.g. if one page redirects to another:
    $Output .= "<script> window.addEventListener(\"message\", (msg) => { if (msg.data == 'ValidAuth') {"  ; 
    $Output .= "  location.reload(); } },false);\r\n"     ;   
    $Output .= "  window.addEventListener(\"resize\", SizeMyFrame);\r\n" ; 
    $Output .= "  var myFrame = document.getElementById(\"MyDBLogin\");" ; 
    $Output .= "  function SizeMyFrame() { myFrame.style.height = myFrame.contentWindow.document.body.scrollHeight + \"px\"; }\r\n" ;  
    $Output .= "</script><!-- /MyLoginPage debug- session_id =" .$SynchID. " -->" ;

  return $Output;

} // end of function MyLoginPage($m)  


## With all that in place, we can build the Markup:
#### fit for PHP5.5 and higher (tested on PHP7.x)

##  First we set the Markup pattern -
    $MDBLpattern = "/\\(:MyDBLogin\\s+(.*):\\)/";

##  Then the Markup itself:
  Markup('MyDBLogin', 'inline', $MDBLpattern, "MyLoginPage");


##---------------------------------------------------------------------------------
##---------------------------------------------------------------------------------

## >>> COPYRIGHT NOTICE FOR THE ORIGINAL INCLUDESITE RECIPE:

/*  Copyright 2004 Patrick R. Michaud (pmichaud@pobox.com)
    This file is distributed under the terms of the GNU General Public 
    License as published by the Free Software Foundation; either 
    version 2 of the License, or (at your option) any later version.  
/*---------------------------------------------------------------

  * Copyright *
  This PmWiki addon was written on March 20, 2004 by Steven Leite
  (steven_leite@kitimat.net).  The same terms and conditions that
  apply to PmWiki also apply to this script.
  
  Update: 
  I have modified the file on march 25, 2019 due to
  the needs of PHP_7.2 and HTML5.
  
  * Special Thanks *
  Thanks to Pm (Patrick Michaud, www.pmichaud.com), for creating
  PmWiki, and for sharing his knowledge and insightfulness which
  is what made this script possible.

  * Description *
  This add-on allows a PmWiki user to include the contents of any
  external webpage into their WikiPage.

  * Features *
  The script won't overwrite any existing configuration date in
  your PmWiki install.

  ...

*/
